<?php

require_once 'vendor/autoload.php';

$host = 'https://faizans-app-fgtklfcc.livekit.cloud';
$apiKey = 'APIUyPiphJAto99';
$apiSecret = 'iMsgmra1EEskHOC0YXhz5uzrMonIFqzbMA6WD5ctzFB';

// Log incoming webhook requests
$input = file_get_contents('php://input');
file_put_contents('webhook_log.txt', $input . PHP_EOL, FILE_APPEND);

$data = json_decode($input, true);

if (isset($data['event'])) {
    $event = $data['event'];
    $roomName = $data['room']['name'] ?? '';
    $participant = $data['participant']['identity'] ?? '';

    switch ($event) {
        case 'participant_joined':
            logMessage("Participant joined: $participant in room $roomName");

            // Start recording
            startRecording($roomName);
            break;

        case 'participant_left':
            logMessage("Participant left: $participant in room $roomName");

            // Stop recording if room is empty
            if (isRoomEmpty($roomName)) {
                stopRecording($roomName);
            }
            break;
    }

    // Send response to LiveKit
    http_response_code(200);
    echo json_encode(['status' => 'ok']);
} else {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Invalid request']);
}

function isRoomEmpty($roomName) {
    global $host, $apiKey, $apiSecret;
    $roomClient = new \Agence104\LiveKit\RoomServiceClient($host, $apiKey, $apiSecret);

    try {
        $participants = $roomClient->listParticipants($roomName);
        logMessage('number of $participants= '. $participants);
        return count($participants) === 0;
    } catch (Exception $e) {
        logMessage("Error checking room participants: " . $e->getMessage());
        return false; // Assume not empty on error
    }
}

function startRecording($roomName) {
    global $host, $apiKey, $apiSecret;
    $egressClient = new \Agence104\LiveKit\EgressServiceClient($host, $apiKey, $apiSecret);

    try {
        // Ensure the directory exists
        $directory = 'recordings';
        if (!is_dir($directory)) {
            mkdir($directory, 0777, true);
        }

        // Generate file path
        $filePath = $directory . "/{$roomName}_" . time() . ".mp4";

        // Set up file output
        $fileOutput = new \Livekit\EncodedFileOutput([
            'filepath' => $filePath,
            "s3"=> new \Livekit\S3Upload(["access_key"=> "AKIA2D7NPXCAJ3XYMVOY", "secret"=> "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", "bucket"=> "mylivekitawsbucket1", "region"=> "us-east-1","metadata"=>["acl" => 'public-read'] ])
            
        ]);

        // Start recording
        $egressInfo = $egressClient->startRoomCompositeEgress($roomName, 'grid', $fileOutput);
        logMessage("Recording started: " . $egressInfo->getId());

    } catch (Exception $e) {
        logMessage("Failed to start recording: " . $e->getMessage());
    }
}


function stopRecording($roomName) {
    global $host, $apiKey, $apiSecret;
    $egressClient = new \Agence104\LiveKit\EgressServiceClient($host, $apiKey, $apiSecret);

    try {
        $response = $egressClient->listEgress($roomName);

        foreach ($response->getEgress() as $egress) {
            $egressClient->stopEgress($egress->getId());
            logMessage("Recording stopped for egress: " . $egress->getId());
        }
    } catch (Exception $e) {
        logMessage("Failed to stop recording: " . $e->getMessage());
    }
}

function logMessage($message) {
    file_put_contents('webhook_log.txt', $message . PHP_EOL, FILE_APPEND);
}
?>
